/**
* \file: main.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <signal.h>

#include <string.h>

#include "control/ald.h"
#include "util/logger.h"

int main(int argc, char* argv[])
{
	error_code_t result;

	result=ald_init(argc,argv);

	if (result==RESULT_OK)
		result=ald_mainloop();

	ald_deinit();

	if (result==RESULT_OK || result==RESULT_HELP_PRINTED)
		return 0;
	else
		return 1;
}
